/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sdp;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import net.sourceforge.peers.Config;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sdp.Codec;
import net.sourceforge.peers.sdp.MediaDescription;
import net.sourceforge.peers.sdp.MediaDestination;
import net.sourceforge.peers.sdp.NoCodecException;
import net.sourceforge.peers.sdp.SdpParser;
import net.sourceforge.peers.sdp.SessionDescription;
import net.sourceforge.peers.sip.core.useragent.UserAgent;

public class SDPManager {
    private SdpParser sdpParser;
    private UserAgent userAgent;
    private List<Codec> supportedCodecs;
    private Random random;
    private Logger logger;

    public SDPManager(UserAgent userAgent, Logger logger) {
        this.userAgent = userAgent;
        this.logger = logger;
        this.sdpParser = new SdpParser();
        this.supportedCodecs = new ArrayList<Codec>();
        this.random = new Random();
        Codec codec = new Codec();
        codec.setPayloadType(0);
        codec.setName("PCMU");
        this.supportedCodecs.add(codec);
        codec = new Codec();
        codec.setPayloadType(8);
        codec.setName("PCMA");
        this.supportedCodecs.add(codec);
        codec = new Codec();
        codec.setPayloadType(101);
        codec.setName("telephone-event");
        this.supportedCodecs.add(codec);
    }

    public SessionDescription parse(byte[] sdp) {
        try {
            return this.sdpParser.parse(sdp);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            return null;
        }
    }

    public MediaDestination getMediaDestination(SessionDescription sessionDescription) throws NoCodecException {
        InetAddress destAddress = sessionDescription.getIpAddress();
        List<MediaDescription> mediaDescriptions = sessionDescription.getMediaDescriptions();
        for (MediaDescription mediaDescription : mediaDescriptions) {
            if (!"audio".equals(mediaDescription.getType())) continue;
            for (Codec offerCodec : mediaDescription.getCodecs()) {
                String offerCodecName;
                if (!this.supportedCodecs.contains(offerCodec) || !(offerCodecName = offerCodec.getName()).equalsIgnoreCase("PCMU") && !offerCodecName.equalsIgnoreCase("PCMA")) continue;
                int destPort = mediaDescription.getPort();
                if (mediaDescription.getIpAddress() != null) {
                    destAddress = mediaDescription.getIpAddress();
                }
                MediaDestination mediaDestination = new MediaDestination();
                mediaDestination.setDestination(destAddress.getHostAddress());
                mediaDestination.setPort(destPort);
                mediaDestination.setCodec(offerCodec);
                return mediaDestination;
            }
        }
        throw new NoCodecException();
    }

    public SessionDescription createSessionDescription(SessionDescription offer, int localRtpPort) throws IOException {
        List<Codec> codecs;
        SessionDescription sessionDescription = new SessionDescription();
        sessionDescription.setUsername("user1");
        sessionDescription.setId(this.random.nextInt(Integer.MAX_VALUE));
        sessionDescription.setVersion(this.random.nextInt(Integer.MAX_VALUE));
        Config config = this.userAgent.getConfig();
        InetAddress inetAddress = config.getPublicInetAddress();
        if (inetAddress == null) {
            inetAddress = config.getLocalInetAddress();
        }
        sessionDescription.setIpAddress(inetAddress);
        sessionDescription.setName("-");
        sessionDescription.setAttributes(new Hashtable<String, String>());
        if (offer == null) {
            codecs = this.supportedCodecs;
        } else {
            codecs = new ArrayList<Codec>();
            for (MediaDescription mediaDescription : offer.getMediaDescriptions()) {
                if (!"audio".equals(mediaDescription.getType())) continue;
                for (Codec codec : mediaDescription.getCodecs()) {
                    if (!this.supportedCodecs.contains(codec)) continue;
                    codecs.add(codec);
                }
            }
        }
        MediaDescription mediaDescription = new MediaDescription();
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        attributes.put("sendrecv", "");
        mediaDescription.setAttributes(attributes);
        mediaDescription.setType("audio");
        mediaDescription.setPort(localRtpPort);
        mediaDescription.setCodecs(codecs);
        ArrayList<MediaDescription> mediaDescriptions = new ArrayList<MediaDescription>();
        mediaDescriptions.add(mediaDescription);
        sessionDescription.setMediaDescriptions(mediaDescriptions);
        return sessionDescription;
    }
}

